<?php
// login_guest.php
// هدف: بررسی وجود مهمان با device_id، اگر بود user_id برگردان، اگر نبود خطا بده

header('Content-Type: application/json');
include 'db_connection.php'; // اتصال به دیتابیس

$data = json_decode(file_get_contents("php://input"), true);

$device_id = $data['device_id'];

$stmt = $conn->prepare("SELECT user_id FROM users WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$result = $stmt->get_result();

if($row = $result->fetch_assoc()) {
    echo json_encode(['status'=>'success','user_id'=>$row['user_id']]);
} else {
    echo json_encode(['status'=>'not_found']);
}

$conn->close();
?>
