<?php
// save_user_map.php
header('Content-Type: application/json');
include 'db_connection.php';

$input = json_decode(file_get_contents("php://input"), true);
if (!$input || !isset($input['user_id']) || !isset($input['user_map'])) {
    http_response_code(400);
    echo json_encode(['status'=>'error','message'=>'invalid_input']);
    exit;
}

$user_id = (int)$input['user_id'];
$user_map = $input['user_map'];

$newJson = json_encode($user_map, JSON_UNESCAPED_UNICODE);
$stmt = $conn->prepare("UPDATE users SET map_level = ? WHERE user_id = ?");
$stmt->bind_param("si", $newJson, $user_id);
$stmt->execute();

echo json_encode(['status'=>'success']);
$conn->close();
exit;
?>
