<?php
// create_guest_account.php
// نسخه حرفه‌ای، ماژولار، قابل توسعه و مجهز به لاگ

header('Content-Type: application/json');
include 'db_connection.php';


// ===============================
// ⚡ تنظیمات قابل تغییر
// ===============================

// فاصله زمانی حمله‌های جدید (پیش‌فرض: ۸ ساعت)
define("ATTACK_INTERVAL", 8 * 3600);

// مسیر ذخیره لاگ
define("LOG_PATH", __DIR__ . "/guest_log.txt");


// ===============================
// 📌 تابع: ثبت لاگ در فایل
// ===============================
function writeLog($msg) {
    $line = "[".date("Y-m-d H:i:s")."] ".$msg."\n";
    file_put_contents(LOG_PATH, $line, FILE_APPEND);
}


// ===============================
// 📌 تابع: ساخت map_data اولیه
// ===============================
function createInitialMapData() {
    return json_encode([
        "map_level" => 1,
        "progress" => 1,
        "attacks" => [],
        "next_attack_time" => time() + ATTACK_INTERVAL
    ], JSON_UNESCAPED_UNICODE);
}


// ===============================
// 📌 تابع: ساخت assets اولیه
// ===============================
function createInitialAssets() {
    return json_encode([
        "coins" => 0,
        "shield" => 0
    ], JSON_UNESCAPED_UNICODE);
}


// ===============================
// 📌 تابع: ساخت equipments اولیه
// ===============================
function createInitialEquipments() {
    return json_encode([
        "gun1_level" => 0,
        "gun2_level" => 0,
        "gun3_level" => 0,
        "gun4_level" => 0,
        "gun5_level" => 0,
        "gun6_level" => 0,
        "ability1_level" => 0,
        "ability2_level" => 0
    ], JSON_UNESCAPED_UNICODE);
}


// ===============================
// 📌 خواندن ورودی
// ===============================
$data = json_decode(file_get_contents("php://input"), true);
$device_id = isset($data['device_id']) ? trim($data['device_id']) : null;

if (!$device_id) {
    writeLog("ERROR: device_id missing");
    echo json_encode(['status'=>'error','message'=>'device_id_missing']);
    exit;
}

writeLog("REQUEST: create guest for device_id = $device_id");


// ===============================
// 📌 بررسی وجود حساب با device_id
// ===============================
$stmt = $conn->prepare("SELECT user_id FROM users WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$res = $stmt->get_result();

if ($row = $res->fetch_assoc()) {
    writeLog("EXISTS: user_id = {$row['user_id']} for device_id = $device_id");
    echo json_encode(['status'=>'exists','user_id'=>$row['user_id']]);
    exit;
}


// ===============================
// 📌 ساخت حساب جدید
// ===============================
$map_data    = createInitialMapData();
$assets      = createInitialAssets();
$equipments  = createInitialEquipments();

$stmt = $conn->prepare("
    INSERT INTO users (device_id, player_level, map_data, assets, equipments)
    VALUES (?, 1, ?, ?, ?)
");
$stmt->bind_param("ssss", $device_id, $map_data, $assets, $equipments);

if ($stmt->execute()) {

    $newID = $stmt->insert_id;
    writeLog("SUCCESS: new user created -> user_id = $newID");

    echo json_encode([
        'status' => 'success',
        'user_id' => $newID
    ]);

} else {

    writeLog("ERROR: failed to create user for device_id = $device_id | SQL: ".$stmt->error);
    echo json_encode(['status'=>'error','message'=>'db_insert_failed']);

}

$conn->close();
?>
